package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MediaType extends DefaultObject {
    private static final SetF<StandardMediaType> VISUAL_VALUES =
            Cf.set(StandardMediaType.IMAGE, StandardMediaType.VIDEO);

    public final String value;

    public MediaType(String value) {
        this.value = value;
    }

    public String getGroup() {
        return isVisual() ? "visual" : "plain";
    }

    boolean isVisual() {
        return VISUAL_VALUES.containsTs(getStandardType());
    }

    public StandardMediaType getStandardType() {
        return StandardMediaType.R.fromValueO(value.toLowerCase()).getOrElse(StandardMediaType.UNKNOWN);
    }
}
