package ru.yandex.chemodan.eventlog.events;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsAddress extends DefaultObject {
    private static final Pattern PATTERN = Pattern.compile("([^:]+):(/.+)", Pattern.DOTALL);

    public final MpfsUid owner;

    public final MpfsPath path;

    public MpfsAddress(MpfsUid owner, MpfsPath path) {
        this.owner = owner;
        this.path = path;
    }

    public static MpfsAddress parseFile(String line) {
        return parse(line, ResourceType.FILE);
    }

    public static MpfsAddress parseDir(String line) {
        return parse(line, ResourceType.DIRECTORY);
    }

    public static MpfsAddress parse(String line, ResourceType resourceType) {
        return parse(line, Option.of(resourceType));
    }

    public static MpfsAddress parse(String line, Option<ResourceType> resourceTypeO) {
        Matcher matcher = PATTERN.matcher(line);

        if (!matcher.matches()) {
            throw new IllegalArgumentException("specified value = " + line + " doesn't match pattern " + PATTERN);
        }

        return new MpfsAddress(
                new MpfsUid(matcher.group(1)),
                MpfsPath.parse(matcher.group(2), resourceTypeO)
        );
    }

    public boolean belongsTo(MpfsUid uid) {
        return this.owner.equals(uid);
    }

    public MpfsAddress getParent() {
        return new MpfsAddress(owner, path.getParent());
    }

    public boolean isRoot() {
        return path.isRoot();
    }

    public String getName() {
        return path.getName();
    }

    @Override
    public String toString() {
        return getRawValue();
    }

    public String getRawValue() {
        return owner.getRawValue() + ":" + path.value;
    }
}
