package ru.yandex.chemodan.eventlog.events;

import org.junit.Test;

import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsAddressTest {
    private static final MpfsUid UID = new MpfsUid(1L);

    private static final String PATH = "/disk/test";

    private static final String MULTILINE_PATH = "/disk/line\nnewline";

    @Test
    public void testParse() {
        Assert.equals(
                new MpfsAddress(UID, MpfsPath.parseFile(PATH)),
                MpfsAddress.parseFile(UID + ":" + PATH)
        );
    }

    @Test(expected = IllegalArgumentException.class)
    public void testIllegalFormat() {
        MpfsAddress.parseFile("some gibberish");
    }

    @Test
    public void testMultiline() {
        Assert.equals(
                new MpfsAddress(UID, MpfsPath.parseFile(MULTILINE_PATH)),
                MpfsAddress.parseFile(UID + ":" + MULTILINE_PATH));
    }
}
