package ru.yandex.chemodan.eventlog.events;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsPathTest {
    @Test
    public void testSimpleName() {
        Assert.equals("image.jpg", MpfsPath.parseFile("/disk/folder/image.jpg").getName());
    }

    @Test
    public void testSlashIsRemovedWhenParsingFile() {
        Assert.equals("/folder/file", MpfsPath.parseFile("/disk/folder/file/").relativePath);
    }

    @Test
    public void testNameWithSlashAtEnd() {
        Assert.equals("subfolder", MpfsPath.parseDir("/disk/folder/subfolder/").getName());
    }

    @Test
    public void testParent() {
        Assert.equals(MpfsPath.parseDir("/disk/folder/"), MpfsPath.parseFile("/disk/folder/video.avi").getParent());
    }

    @Test
    public void testService() {
        Assert.equals("disk", MpfsPath.parseFile("/disk/folder/video.avi").service);
    }

    @Test
    public void testMultiline() {
        Assert.equals(
                new MpfsPath("disk", "/line\nnewline/", ResourceType.DIRECTORY),
                MpfsPath.parseDir("/disk/line\nnewline/")
        );
    }

    @Test
    public void testRoot() {
        assertIsRoot(MpfsPath.parseDir("/disk"));
    }

    @Test
    public void testRootEndingInSlash() {
        assertIsRoot(MpfsPath.parseDir("/disk/"));
    }

    @Test
    public void testRootParsedAsFile() {
        assertIsRoot(MpfsPath.parseFile("/disk"));
    }

    private void assertIsRoot(MpfsPath actualPath) {
        Assert.equals(new MpfsPath("disk", "/", ResourceType.DIRECTORY), actualPath);
        Assert.isTrue(actualPath.isRoot());
    }

    @Test
    public void testThatRootNameIsEmpty() {
        Assert.equals("", MpfsPath.parseDir("/disk").getName());
    }

    @Test
    public void testThatRootParentIsRoot() {
        Assert.equals(MpfsPath.parseDir("/disk"), MpfsPath.parseDir("/disk").getParent());
    }
}
