package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class Resource extends DefaultObject {
    @BenderFlatten
    public final CompoundResourceType compoundType;

    @BenderPart(name = "resource_file_id", strictName = true)
    public final String fileId;

    @BenderPart(name = "owner_uid", strictName = true)
    public final MpfsUid owner;

    @BenderPart(name = "resource_public_key", strictName = true)
    public final Option<String> publicKey;

    @BenderPart(name = "resource_short_url", strictName = true)
    public final Option<String> shortUrl;

    @BenderPart(name = "resource_overwritten", strictName = true)
    public final Option<Boolean> overwritten;

    private Resource(CompoundResourceType compoundType, String fileId, MpfsUid owner) {
        this(compoundType, fileId, owner, Option.empty(), Option.empty(), Option.empty());
    }

    private Resource(CompoundResourceType compoundType, String fileId, MpfsUid owner,
            Option<String> publicKey, Option<String> shortUrl, Option<Boolean> overwritten)
    {
        this.compoundType = compoundType;
        this.fileId = fileId;
        this.owner = owner;
        this.publicKey = publicKey;
        this.shortUrl = shortUrl;
        this.overwritten = overwritten;
    }

    public static Resource file(String mediaType, String fileId, MpfsUid owner) {
        return new Resource(CompoundResourceType.file(mediaType), fileId, owner);
    }

    public static Resource directory(String fileId, MpfsUid owner) {
        return new Resource(CompoundResourceType.directory(), fileId, owner);
    }

    public Resource withKeyAndUrl(String publicKey, String shortUrl) {
        return withKeyAndUrlO(Option.of(publicKey), Option.of(shortUrl));
    }

    public Resource withKeyAndUrlO(Option<String> publicKey, Option<String> shortUrl) {
        return new Resource(compoundType, fileId, owner, publicKey, shortUrl, overwritten);
    }

    public Resource withOverwritten(boolean overwritten) {
        return withOverwrittenO(Option.of(overwritten));
    }

    public Resource withOverwrittenO(Option<Boolean> overwritten) {
        return new Resource(compoundType, fileId, owner, publicKey, shortUrl, overwritten);
    }
}
