package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsResourceId;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class ResourceLocation extends DefaultObject {

    public final MpfsAddress address;

    public final Option<MpfsResourceId> folderId;

    public ResourceLocation(MpfsAddress address, Option<MpfsResourceId> folderId) {
        this.address = address;
        this.folderId = folderId;
    }

    public MpfsAddress getAddress() {
        return address;
    }

    public MpfsAddress getParentAddress() {
        return address.getParent();
    }

    public MpfsPath getParentAddressPath() {
        return address.path.getParent();
    }
}
