package ru.yandex.chemodan.eventlog.events;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum ResourceType implements StringEnum {
    DIRECTORY("dir"), FILE("file"), ALBUM("album");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<ResourceType> R = StringEnumResolver.r(ResourceType.class);
}
