package ru.yandex.chemodan.eventlog.events;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ResourceTypeTest {
    @Test
    public void testParseDir() {
        testParse("dir", ResourceType.DIRECTORY);
    }

    @Test
    public void testParseFile() {
        testParse("file", ResourceType.FILE);
    }

    @Test
    public void testParseFileO() {
        Assert.equals(Option.of(ResourceType.FILE), Option.of("file").flatMapO(ResourceType.R::fromValueO));
    }

    private void testParse(String resourceTypeStr, ResourceType expectedResourceType) {
        Assert.equals(expectedResourceType, ResourceType.R.fromValue(resourceTypeStr));
    }
}
