package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class SourceInfo extends DefaultObject {
    static final SourceInfo EMPTY = new SourceInfo(Option.empty(), Option.empty());

    @BenderPart(name="source_folder", strictName = true)
    public final Option<String> sourceParent;

    @BenderPart(name="source_path", strictName = true)
    public final Option<String> sourcePath;

    SourceInfo(String sourceParent, String sourcePath) {
        this(Option.of(sourceParent), Option.of(sourcePath));
    }

    private SourceInfo(Option<String> sourceParent, Option<String> sourcePath) {
        this.sourceParent = sourceParent;
        this.sourcePath = sourcePath;
    }

    public static SourceInfo fromAddress(MpfsUid owner, Option<MpfsAddress> address) {
        if (!address.isPresent()) {
            return EMPTY;
        }

        return fromAddress(owner, address.get());
    }

    public static SourceInfo fromAddress(MpfsUid owner, MpfsAddress address) {
        if (!address.belongsTo(owner)) {
            return EMPTY;
        }

        return fromPath(address.path);
    }

    private static SourceInfo fromPath(MpfsPath path) {
        return new SourceInfo(path.getParent().toString(), path.toString());
    }
}
