package ru.yandex.chemodan.eventlog.events;

import org.junit.Test;

import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SourceInfoTest {
    @Test
    public void testFromAddressForOwner() {
        Assert.equals(
                new SourceInfo("/disk/dir/", "/disk/dir/file.txt"),
                SourceInfo.fromAddress(new MpfsUid(777L), MpfsAddress.parseFile("777:/disk/dir/file.txt"))
        );
    }
    @Test
    public void testFromAddressForNonOwner() {
        Assert.equals(
                SourceInfo.EMPTY,
                SourceInfo.fromAddress(new MpfsUid(123L), MpfsAddress.parseFile("777:/disk/dir/file.txt"))
        );
    }
}
