package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SpecificEventTypeResolver<T extends SpecificEventType> {
    private final MapF<TskvEventType, T> tskvToSpecific;

    @SafeVarargs
    public SpecificEventTypeResolver(T... values) {
        tskvToSpecific = Cf.list(values).toMapMappingToKey(T::getTskvType);
    }

    public T byTskvType(TskvEventType type) {
        return tskvToSpecific.getTs(type);
    }
}
