package ru.yandex.chemodan.eventlog.events;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum StandardMediaType implements StringEnum {
    IMAGE("image"),
    VIDEO("video"),
    AUDIO("audio"),
    FLASH("flash"),
    DOCUMENT("document"),
    TEXT("text"),
    BACKUP("backup"),
    BOOK("book"),
    COMPRESSED("compressed"),
    DATA("data"),
    DEVELOPMENT("development"),
    DISK_IMAGE("diskimage"),
    ENCODED("encoded"),
    EXECUTABLE("executable"),
    FONT("font"),
    SETTINGS("settings"),
    SPREADSHEET("spreadsheet"),
    WEB("web"),
    UNKNOWN("unknown"),
    ;

    private final String value;

    StandardMediaType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<StandardMediaType> R = new StringEnumResolver<>(StandardMediaType.class);
}
