package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class TargetInfo extends DefaultObject {
    static final TargetInfo EMPTY = new TargetInfo(Option.empty(), Option.empty());

    @BenderPart(name="target_folder", strictName = true)
    public final Option<String> targetParent;

    @BenderPart(name="target_path", strictName = true)
    public final Option<String> targetPath;

    TargetInfo(String targetParent, String targetPath) {
        this(Option.of(targetParent), Option.of(targetPath));
    }

    private TargetInfo(Option<String> targetParent, Option<String> targetPath) {
        this.targetParent = targetParent;
        this.targetPath = targetPath;
    }

    public static TargetInfo fromAddress(MpfsUid owner, Option<MpfsAddress> address) {
        if (!address.isPresent()) {
            return EMPTY;
        }

        return fromAddress(owner, address.get());
    }

    public static TargetInfo fromAddress(MpfsUid owner, MpfsAddress address) {
        if (!address.belongsTo(owner)) {
            return EMPTY;
        }

        return fromPath(address.path);
    }

    private static TargetInfo fromPath(MpfsPath path) {
        return new TargetInfo(path.getParent().toString(), path.toString());
    }
}
