package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class UniverseInvite extends DefaultObject {
    public static final UniverseInvite EMPTY = new UniverseInvite(Option.empty(), Option.empty());

    @BenderPart(name = "invite_login", strictName = true)
    protected final Option<String> login;

    @BenderPart(name = "invite_service", strictName = true)
    protected final Option<String> service;

    public UniverseInvite(String login, String service) {
        this(Option.of(login), Option.of(service));
    }

    private UniverseInvite(Option<String> login, Option<String> service) {
        this.login = login;
        this.service = service;
    }

    public String getLogin() {
        return login.getOrElse("");
    }

    public String getService() {
        return service.getOrElse("");
    }

    public boolean isEmpty() {
        return !service.isPresent() && !login.isPresent();
    }
}
