package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class YandexCloudRequestId extends DefaultObject {
    private static final String SEPARATOR = "-";

    public final String prefix;
    public final String platform;
    public final String id;
    public final String host;

    public YandexCloudRequestId(String prefix, String id, String host) {
        this.prefix = prefix;
        this.platform = extractPlatform(prefix);
        this.id = id;
        this.host = host;
    }

    private static String extractPlatform(String prefix) {
        return prefix.replaceAll("^rest_", "");
    }

    public static YandexCloudRequestId parse(String value) {
        ListF<String> chunks = Cf.list(value.split(SEPARATOR));
        String prefix = chunks.first();
        String id = StringUtils.join(chunks.subList(1, chunks.length() - 1), SEPARATOR);
        String host = chunks.last();
        return new YandexCloudRequestId(prefix, id, host);
    }

    public String toString() {
        return StringUtils.join(Cf.list(prefix, id, host), SEPARATOR);
    }
}
