package ru.yandex.chemodan.eventlog.events;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemen)
 */
public class YandexCloudRequestIdTest {
    @Test
    public void testParse() {
        Assert.equals(
                new YandexCloudRequestId("mpfs", "d65d8cc3854f675d30eb0b7232567452", "webdav1o"),
                YandexCloudRequestId.parse("mpfs-d65d8cc3854f675d30eb0b7232567452-webdav1o")
        );
    }

    @Test
    public void testToString() {
        String ycRid = "rest-123-345-678-lemeh-precise";
        Assert.equals(ycRid, YandexCloudRequestId.parse(ycRid).toString());
    }

    @Test
    public void testRegularPlatform() {
        Assert.equals("win", new YandexCloudRequestId("win", "123", "mpfs2j").platform);
    }

    @Test
    public void testRestPlatform() {
        Assert.equals("ios", new YandexCloudRequestId("rest_ios", "123", "mpfs2j").platform);
    }
}
