package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractAlbumItemEvent extends AbstractAlbumEvent {
    @BenderIgnore
    private final AlbumItemEventType eventType;

    @BenderFlatten
    private final AlbumItem item;

    protected AbstractAlbumItemEvent(EventMetadata metadata, AlbumItem item, AlbumItemEventType eventType) {
        super(metadata);
        this.eventType = eventType;
        this.item = item;
    }

    public static AbstractAlbumItemEvent parse(TskvEventLogLine tskv) {
        AlbumItem item = tskv.getAlbumItem();
        AlbumItemEventType itemEventType = tskv.getAlbumItemEventType();
        if (item.type == AlbumItemType.ALBUM) {
            return new ChildAlbumItemEvent(
                    tskv.getMetadata(),
                    item, itemEventType,
                    tskv.getString("child_album_id"),
                    tskv.getString("child_album_title")
            );
        } else {
            return new ResourceAlbumItemEvent(
                    tskv.getMetadata(),
                    item, itemEventType,
                    tskv.getAddress("resource_address"),
                    tskv.getResource()
            );
        }
    }

    @Override
    public EventType getEventType() {
        return eventType.eventType;
    }

    public abstract String getItemName();

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(item.album.id);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list(getItemName());
    }
}
