package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractBasicAlbumEvent extends AbstractAlbumEvent {
    @BenderFlatten
    public final Album album;

    protected AbstractBasicAlbumEvent(EventMetadata metadata, Album album) {
        super(metadata);
        this.album = album;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(album.id);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list();
    }
}
