package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum AlbumItemType implements StringEnum {
    RESOURCE("resource"), SHARED_RESOURCE("shared_resource"), ALBUM("album");

    private final String value;

    AlbumItemType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<AlbumItemType> R = StringEnumResolver.r(AlbumItemType.class);
}
