package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ChangeCoverOffsetAlbumEvent extends AbstractBasicAlbumEvent {
    public ChangeCoverOffsetAlbumEvent(EventMetadata metadata, Album album) {
        super(metadata, album);
    }

    public static ChangeCoverOffsetAlbumEvent parse(TskvEventLogLine tskv) {
        return new ChangeCoverOffsetAlbumEvent(tskv.getMetadata(), tskv.getAlbum());
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_CHANGE_COVER_OFFSET;
    }
}
