package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ChangePublicityAlbumEvent extends AbstractBasicAlbumEvent {
    @BenderPart(name = "album_is_public", strictName = true)
    public final boolean isPublic;

    public ChangePublicityAlbumEvent(EventMetadata metadata, Album album, boolean isPublic) {
        super(metadata, album);
        this.isPublic = isPublic;
    }

    public static ChangePublicityAlbumEvent parse(TskvEventLogLine tskv) {
        return new ChangePublicityAlbumEvent(
                tskv.getMetadata(),
                tskv.getAlbum(),
                tskv.getBoolean("album_is_public"));
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_CHANGE_PUBLICITY;
    }
}
