package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ChangeTitleAlbumEvent extends AbstractBasicAlbumEvent {
    @BenderPart(name = "album_prev_title", strictName = true)
    public final String prevTitle;

    public ChangeTitleAlbumEvent(EventMetadata metadata, Album album, String prevTitle) {
        super(metadata, album);
        this.prevTitle = prevTitle;
    }

    public static ChangeTitleAlbumEvent parse(TskvEventLogLine tskv) {
        return new ChangeTitleAlbumEvent(
                tskv.getMetadata(),
                tskv.getAlbum(),
                tskv.getString("prev_album_title"));
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_CHANGE_TITLE;
    }
}
