package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ChildAlbumItemEvent extends AbstractAlbumItemEvent {
    @BenderPart(name = "child_album_id", strictName = true)
    public final String childAlbumId;

    @BenderPart(name = "child_album_title", strictName = true)
    public final String childAlbumTitle;

    public ChildAlbumItemEvent(EventMetadata metadata, AlbumItem item, AlbumItemEventType eventType,
            String childAlbumId, String childAlbumTitle)
    {
        super(metadata, item, eventType);
        this.childAlbumId = childAlbumId;
        this.childAlbumTitle = childAlbumTitle;
    }

    @Override
    public String getItemName() {
        return childAlbumId;
    }
}
