package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderIgnore;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class CreateAlbumEvent extends AbstractBasicAlbumEvent {
    @BenderIgnore
    public final Option<Integer> itemAmount;

    private CreateAlbumEvent(EventMetadata metadata, Album album, Option<Integer> itemAmount) {
        super(metadata, album);
        this.itemAmount = itemAmount;
    }

    public CreateAlbumEvent(EventMetadata metadata, Album album) {
        this(metadata, album, Option.empty());
    }

    public CreateAlbumEvent(EventMetadata metadata, Album album, int itemAmount) {
        this(metadata, album, Option.of(itemAmount));
    }

    public static CreateAlbumEvent parse(TskvEventLogLine tskv) {
        return new CreateAlbumEvent(tskv.getMetadata(), tskv.getAlbum(), tskv.getIntegerO("album_item_count"));
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_CREATE;
    }

    @Override
    protected boolean rejectInternal() {
        return itemAmount.isPresent() && itemAmount.get() != 0;
    }
}
