package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class PostToSocialAlbumEvent extends AbstractBasicAlbumEvent {
    @BenderPart(name = "invite_service", strictName = true)
    public final String provider;

    public PostToSocialAlbumEvent(EventMetadata metadata, Album album, String provider) {
        super(metadata, album);
        this.provider = provider;
    }

    public static PostToSocialAlbumEvent parse(TskvEventLogLine tskv) {
        return new PostToSocialAlbumEvent(
                tskv.getMetadata(),
                tskv.getAlbum(),
                tskv.getString("provider"));
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_POST_TO_SOCIAL;
    }
}
