package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class RemoveAlbumEvent extends AbstractBasicAlbumEvent {
    public RemoveAlbumEvent(EventMetadata metadata, Album album) {
        super(metadata, album);
    }

    public static RemoveAlbumEvent parse(TskvEventLogLine tskv) {
        return new RemoveAlbumEvent(tskv.getMetadata(), tskv.getAlbum());
    }

    @Override
    public EventType getEventType() {
        return EventType.ALBUM_REMOVE;
    }
}
