package ru.yandex.chemodan.eventlog.events.album;

import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.MpfsAddress;
import ru.yandex.chemodan.eventlog.events.Resource;
import ru.yandex.chemodan.eventlog.events.SourceInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class ResourceAlbumItemEvent extends AbstractAlbumItemEvent {
    @BenderIgnore
    public final MpfsAddress source;

    @BenderFlatten
    public final SourceInfo sourceInfo;

    @BenderFlatten
    public final Resource resource;

    public ResourceAlbumItemEvent(EventMetadata metadata, AlbumItem item, AlbumItemEventType eventType,
            MpfsAddress source, Resource resource)
    {
        super(metadata, item, eventType);
        this.source = source;
        this.sourceInfo = SourceInfo.fromAddress(metadata.uid, source);
        this.resource = resource;
    }

    public String getItemName() {
        return source.getName();
    }
}
