package ru.yandex.chemodan.eventlog.events.billing;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class BillingEvent extends AbstractEvent {
    public final BillingEventType eventType;

    @BenderFlatten
    public final Product product;

    @BenderFlatten
    public final Payment payment;

    public final boolean auto;

    public BillingEvent(BillingEventType eventType, EventMetadata metadata, Product product, Payment payment,
            boolean auto)
    {
        super(metadata);
        this.eventType = eventType;
        this.product = product;
        this.payment = payment;
        this.auto = auto;
    }

    public static BillingEvent parse(TskvEventLogLine tskv) {
        return new BillingEvent(
                BillingEventType.R.byTskvType(tskv.getEventType()),
                tskv.getMetadata(),
                tskv.getProduct(),
                tskv.getSharePayment(),
                tskv.getBoolean("auto")
        );
    }

    @Override
    public EventType getEventType() {
        return eventType.getGlobalType(this);
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(product.id);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list().plus(payment.price).plus(payment.currency);
    }
}
