package ru.yandex.chemodan.eventlog.events.billing;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum BillingEventType implements SpecificEventType {
    BUY_NEW(TskvEventType.BILLING_BUY_NEW,
            event -> event.payment.status.isSuccess()
                    ? (event.auto ? EventType.BILLING_SUBSCRIBE : EventType.BILLING_BUY_NEW)
                    : EventType.SKIP),
    PROLONG(TskvEventType.BILLING_PROLONG,
            event -> event.payment.status.isSuccess() ? EventType.BILLING_PROLONG : EventType.BILLING_PROLONG_ERROR),
    ORDER_NEW(TskvEventType.BILLING_ORDER_NEW, EventType.BILLING_ORDER_NEW),
    DELETE(TskvEventType.BILLING_DELETE, EventType.BILLING_DELETE),
    UNSUBSCRIBE(TskvEventType.BILLING_UNSUBSCRIBE, EventType.BILLING_UNSUBSCRIBE);

    final Function<BillingEvent, EventType> globalTypeF;

    final TskvEventType tskvType;

    BillingEventType(TskvEventType tskvType, Function<BillingEvent, EventType> globalTypeF) {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
    }

    BillingEventType(TskvEventType tskvType, EventType globalType) {
        this(tskvType, event -> globalType);
    }

    public EventType getGlobalType(BillingEvent event) {
        return globalTypeF.apply(event);
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public static final SpecificEventTypeResolver<BillingEventType> R = new SpecificEventTypeResolver<>(values());
}
