package ru.yandex.chemodan.eventlog.events.billing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class PaymentStatus extends DefaultObject {
    public static final PaymentStatus NONE = new PaymentStatus(Option.empty(), Option.empty());

    private static final String SUCCESS_VALUE = "success";

    @BenderIgnore
    public final Option<String> status;

    @BenderPart(name = "reason", strictName = true)
    public final Option<String> code;

    private PaymentStatus(Option<String> status, Option<String> code) {
        this.status = status;
        this.code = code;
    }

    public PaymentStatus(String status) {
        this(Option.of(status), Option.empty());
    }

    public PaymentStatus(String status, String code) {
        this(Option.of(status), Option.of(code));
    }

    public static PaymentStatus cons(Option<String> status, Option<String> statusCode) {
        if (!status.isPresent() && !statusCode.isPresent()) {
            return NONE;
        }
        return new PaymentStatus(status, statusCode);
    }

    public boolean isSuccess() {
        return status.isPresent() && status.get().equals(SUCCESS_VALUE);
    }
}
