package ru.yandex.chemodan.eventlog.events.billing;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class Product extends DefaultObject {
    @BenderPart(name = "product_id", strictName = true)
    public final String id;

    @BenderFlatten
    public final ProductNames names;

    @BenderPart(name = "product_period", strictName = true)
    public final Option<String> period;

    public final boolean free;

    public Product(String id, MapF<String, String> names, String period, boolean free) {
        this(id, names, Option.of(period), free);
    }

    public Product(String id, MapF<String, String> names, Option<String> period, boolean free) {
        this.id = id;
        this.names = new ProductNames(names);
        this.period = period;
        this.free = free;
    }

    public Tuple2List<String, String> toKeyValue() {
        Tuple2List<String, String> result =
                Tuple2List.<String, String>arrayList()
                        .plus1("product_id", id);

        if (period.isPresent()) {
            result = result.plus1("product_period", period.get());
        }

        return result.plus1(
                "product_is_free",
                StringUtils.capitalize(String.valueOf(free))
        );
    }
}
