package ru.yandex.chemodan.eventlog.events.billing;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin
 */
@Bendable
public class ProductNames extends DefaultObject {
    public final MapF<String, String> namesMap;

    public ProductNames(MapF<String, String> namesMap) {
        this.namesMap = namesMap;
    }

    @BenderPart(name = "product_name_ru", strictName = true)
    public String getNameRu() {
        return namesMap.getTs("product_name_ru");
    }

    @BenderPart(name = "product_name_ua", strictName = true)
    public String getNameUa() {
        return namesMap.getTs("product_name_ua");
    }

    @BenderPart(name = "product_name_en", strictName = true)
    public String getNameEn() {
        return namesMap.getTs("product_name_en");
    }

    @BenderPart(name = "product_name_tr", strictName = true)
    public String getNameTr() {
        return namesMap.getTs("product_name_tr");
    }
}
