package ru.yandex.chemodan.eventlog.events.client;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
@Data
public class EventValue {

    @BenderPart(name = "MainActivity", strictName = true)
    private final Option<String> mainActivity;

    private final Option<String> ui;

    private final Option<EventValueMetrics> metrics;

    public EventValue(Option<String> mainActivity, Option<String> ui, Option<EventValueMetrics> metrics) {
        this.mainActivity = mainActivity;
        this.ui = ui;
        this.metrics = metrics;
    }
}
