package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.commentaries.EntityTypes;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsResourceId;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
public abstract class AbstractCommentEvent<TEvent extends AbstractCommentEvent<TEvent>> extends AbstractEvent {
    @BenderPart(name = "user_uid", strictName = true)
    public final MpfsUid performerUid;
    @BenderFlatten
    public final EntityRef entity;
    @BenderIgnore
    public final ListF<PassportUid> extraRecipients;

    public AbstractCommentEvent(
            EventMetadata metadata, MpfsUid performerUid, EntityRef entity, ListF<PassportUid> extraRecipients)
    {
        super(metadata);
        this.performerUid = performerUid;
        this.entity = entity;
        this.extraRecipients = extraRecipients.filterNot(metadata.uid.getUidO()::isSome);
    }

    @Override
    protected ListF<AbstractEvent> createExtraEvents() {
        return extraRecipients.map(uid -> withMetadata(metadata.withUid(new MpfsUid(uid))));
    }

    protected static MpfsUid getEntityOwner(TskvEventLogLine tskv) {
        return MpfsResourceId.parse(tskv.getString(CommentsTskvFields.ENTITY_ID)).owner;
    }

    public TEvent withFileInfo(MpfsFileInfo info) {
        return withEntity(entity.withFileInfo(info));
    }

    public abstract TEvent withExtraRecipients(ListF<PassportUid> extraRecipients);

    protected abstract TEvent withEntity(EntityRef ref);

    protected abstract TEvent withMetadata(EventMetadata metadata);

    public boolean isPublicResource() {
        return entity.type.equals(EntityTypes.PUBLIC_RESOURCE);
    }

    public boolean isPrivateResource() {
        return entity.type.equals(EntityTypes.PRIVATE_RESOURCE);
    }

    public boolean isResource() {
        return isPublicResource() || isPrivateResource();
    }
}
