package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@Bendable
public class CommentEvent extends AbstractCommentEvent<CommentEvent> {
    @BenderIgnore
    public final CommentEventType eventType;
    @BenderPart(name = "comment_type", strictName = true)
    public final CommentType commentType;
    @BenderFlatten
    public final CommentRef comment;
    @BenderFlatten
    public final ParentCommentRef parent;

    public CommentEvent(
            CommentEventType eventType, EventMetadata metadata,
            MpfsUid performerUid, EntityRef entity,
            CommentRef comment, ParentCommentRef parent, ListF<PassportUid> extraRecipients)
    {
        super(metadata, performerUid, entity, extraRecipients);
        this.eventType = eventType;
        this.commentType = parent.isEmpty() ? CommentType.TOPIC : CommentType.REPLY;
        this.comment = comment;
        this.parent = parent;
    }

    @Override
    public EventType getEventType() {
        return eventType.getGlobalType(this);
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(entity.type, entity.id);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return comment.commentId.cast();
    }

    @Override
    public CommentEvent withExtraRecipients(ListF<PassportUid> extraRecipients) {
        return new CommentEvent(eventType, metadata, performerUid, entity, comment, parent, extraRecipients);
    }

    @Override
    protected CommentEvent withEntity(EntityRef entity) {
        return new CommentEvent(eventType, metadata, performerUid, entity, comment, parent, extraRecipients);
    }

    @Override
    protected CommentEvent withMetadata(EventMetadata metadata) {
        return new CommentEvent(eventType, metadata, performerUid, entity, comment, parent, extraRecipients);
    }

    public static CommentEvent parse(TskvEventLogLine tskv) {
        return new CommentEvent(
                CommentEventType.R.byTskvType(tskv.getEventType()),
                tskv.getMetadata(getEntityOwner(tskv)),
                tskv.getPassportUid(CommentsTskvFields.USER_UID),
                EntityRef.parse(tskv), CommentRef.parse(tskv), ParentCommentRef.parse(tskv), Cf.list());
    }
}
