package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author dbrylev
 */
public enum CommentEventType implements SpecificEventType {
    COMMENT_ADD(TskvEventType.COMMENT_ADD, EventType.COMMENT_ADD),
    COMMENT_DELETE(TskvEventType.COMMENT_DELETE, EventType.COMMENT_DELETE),
    COMMENT_RESTORE(TskvEventType.COMMENT_RESTORE, EventType.COMMENT_RESTORE),
    ;

    private final Function<CommentEvent, EventType> globalTypeF;

    private final TskvEventType tskvType;

    CommentEventType(TskvEventType tskvType, EventType globalType) {
        this(tskvType, t -> globalType);
    }

    CommentEventType(TskvEventType tskvType, Function<CommentEvent, EventType> globalTypeF) {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public EventType getGlobalType(CommentEvent event) {
        return globalTypeF.apply(event);
    }

    public static final SpecificEventTypeResolver<CommentEventType> R = new SpecificEventTypeResolver<>(values());
}
