package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@Bendable
public class CommentRef extends DefaultObject {
    @BenderPart(name = "comment_id", strictName = true)
    public final Option<String> commentId;
    @BenderPart(name = "comment_author_uid", strictName = true)
    public final Option<MpfsUid> commentAuthorUid;
    @BenderPart(name = "comment_text", strictName = true)
    public final Option<String> commentText;

    public CommentRef(Option<String> commentId, Option<MpfsUid> commentAuthorUid, Option<String> commentText) {
        this.commentId = commentId;
        this.commentAuthorUid = commentAuthorUid;
        this.commentText = commentText;
    }

    public CommentRef(String commentId, MpfsUid commentAuthorUid, String commentText) {
        this(Option.of(commentId), Option.of(commentAuthorUid), Option.of(commentText));
    }

    public static CommentRef parse(TskvEventLogLine tskv) {
        return new CommentRef(
                tskv.getNonEmptyStringO(CommentsTskvFields.COMMENT_ID),
                tskv.getPassportUidO(CommentsTskvFields.COMMENT_AUTHOR_UID),
                tskv.getNonEmptyStringO(CommentsTskvFields.COMMENT_TEXT));
    }

    public boolean isEmpty() {
        return !commentId.isPresent() && !commentAuthorUid.isPresent();
    }
}
