package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum CommentType implements StringEnum {
    TOPIC("topic"), REPLY("reply");

    private final String value;

    CommentType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<CommentType> R = StringEnumResolver.r(CommentType.class);
}
