package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.eventlog.events.ResourceType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@Bendable
public class EntityRef extends DefaultObject {
    @BenderPart(name = "entity_type", strictName = true)
    public final String type;
    @BenderPart(name = "entity_id", strictName = true)
    public final String id;
    @BenderPart(name = "resource_name", strictName = true)
    public final Option<String> resourceName;
    @BenderPart(name = "resource_type", strictName = true)
    public final Option<ResourceType> resourceType;

    public EntityRef(String type, String id) {
        this(type, id, Option.empty(), Option.empty());
    }

    public EntityRef(String type, String id, ResourceType resourceType) {
        this(type, id, Option.empty(), Option.of(resourceType));
    }

    public EntityRef(String type, String id, Option<String> resourceName, Option<ResourceType> resourceType) {
        this.type = type;
        this.id = id;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
    }

    public static EntityRef parse(TskvEventLogLine tskv) {
        return new EntityRef(
                tskv.getString(CommentsTskvFields.ENTITY_TYPE),
                tskv.getString(CommentsTskvFields.ENTITY_ID));
    }

    public EntityRef withFileInfo(MpfsFileInfo info) {
        return new EntityRef(type, id, info.name, info.type.flatMapO(ResourceType.R::fromValueO));
    }
}
