package ru.yandex.chemodan.eventlog.events.comment;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.ResourceType;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsFileMetaDto;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EntityRefTest {
    @Test
    public void testWithFileInfoForDirectory() {
        testWithFileInfo("dir", ResourceType.DIRECTORY);
    }

    @Test
    public void testWithFileInfoForFile() {
        testWithFileInfo("file", ResourceType.FILE);
    }

    private void testWithFileInfo(String resourceTypeStr, ResourceType expectedResourceType) {
        EntityRef entityRef = new EntityRef("public_resource", "1")
                .withFileInfo(new MpfsFileInfo("dir_name", resourceTypeStr, Mockito.mock(MpfsFileMetaDto.class)));
        Assert.equals(Option.of(expectedResourceType), entityRef.resourceType);
    }
}
