package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum LikableType implements StringEnum {
    ENTITY("entity"), COMMENT("comment");

    private final String value;

    LikableType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<LikableType> R = StringEnumResolver.r(LikableType.class);
}
