package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@Bendable
public class LikeDislikeEvent extends AbstractCommentEvent<LikeDislikeEvent> {
    @BenderIgnore
    public final LikeDislikeEventType eventType;
    @BenderPart(name = "comment_type", strictName = true)
    public final LikableType commentType;
    @BenderFlatten
    public final CommentRef comment;

    public LikeDislikeEvent(
            LikeDislikeEventType eventType, EventMetadata metadata,
            MpfsUid performerUid, EntityRef entity, CommentRef comment, ListF<PassportUid> extraRecipients)
    {
        super(metadata, performerUid, entity, extraRecipients);
        this.eventType = eventType;
        this.commentType = comment.isEmpty() ? LikableType.ENTITY : LikableType.COMMENT;
        this.comment = comment;
    }

    @Override
    public EventType getEventType() {
        return eventType.getGlobalType(this);
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list(entity.type, entity.id);
    }

    @Override
    public ListF<Object> getNameChunks() {
        return comment.commentId.cast().plus1(performerUid);
    }

    @Override
    protected boolean acceptInternal() {
        return commentType == LikableType.ENTITY;
    }

    @Override
    public LikeDislikeEvent withExtraRecipients(ListF<PassportUid> extraRecipients) {
        return new LikeDislikeEvent(eventType, metadata, performerUid, entity, comment, extraRecipients);
    }

    @Override
    protected LikeDislikeEvent withEntity(EntityRef entity) {
        return new LikeDislikeEvent(eventType, metadata, performerUid, entity, comment, extraRecipients);
    }

    @Override
    protected LikeDislikeEvent withMetadata(EventMetadata metadata) {
        return new LikeDislikeEvent(eventType, metadata, performerUid, entity, comment, extraRecipients);
    }

    public static LikeDislikeEvent parse(TskvEventLogLine tskv) {
        return new LikeDislikeEvent(
                LikeDislikeEventType.R.byTskvType(tskv.getEventType()),
                tskv.getMetadata(getEntityOwner(tskv)),
                tskv.getPassportUid(CommentsTskvFields.USER_UID),
                EntityRef.parse(tskv), CommentRef.parse(tskv), Cf.list());
    }
}
