package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author dbrylev
 */
public enum LikeDislikeEventType implements SpecificEventType {
    LIKE_ADD(TskvEventType.COMMENT_LIKE_ADD, EventType.COMMENT_LIKE_ADD),
    LIKE_DELETE(TskvEventType.COMMENT_LIKE_DELETE, EventType.COMMENT_LIKE_DELETE),
    DISLIKE_ADD(TskvEventType.COMMENT_DISLIKE_ADD, EventType.COMMENT_DISLIKE_ADD),
    DISLIKE_DELETE(TskvEventType.COMMENT_DISLIKE_DELETE, EventType.COMMENT_DISLIKE_DELETE),
    ;

    private final Function<LikeDislikeEvent, EventType> globalTypeF;

    private final TskvEventType tskvType;

    LikeDislikeEventType(TskvEventType tskvType, EventType globalType) {
        this(tskvType, t -> globalType);
    }

    LikeDislikeEventType(TskvEventType tskvType, Function<LikeDislikeEvent, EventType> globalTypeF) {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public EventType getGlobalType(LikeDislikeEvent event) {
        return globalTypeF.apply(event);
    }

    public static final SpecificEventTypeResolver<LikeDislikeEventType> R = new SpecificEventTypeResolver<>(values());
}
