package ru.yandex.chemodan.eventlog.events.comment;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.commentaries.CommentsTskvFields;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@Bendable
public class ParentCommentRef extends DefaultObject {
    @BenderPart(name = "parent_comment_id", strictName = true)
    public final Option<String> parentCommentId;
    @BenderPart(name = "parent_author_uid", strictName = true)
    public final Option<MpfsUid> parentAuthorUid;

    public ParentCommentRef(Option<String> commentId, Option<MpfsUid> authorUid) {
        this.parentCommentId = commentId;
        this.parentAuthorUid = authorUid;
    }

    public ParentCommentRef(String commentId, MpfsUid authorUid) {
        this(Option.of(commentId), Option.of(authorUid));
    }

    public static ParentCommentRef parse(TskvEventLogLine tskv) {
        return new ParentCommentRef(
                tskv.getNonEmptyStringO(CommentsTskvFields.PARENT_COMMENT_ID),
                tskv.getPassportUidO(CommentsTskvFields.PARENT_AUTHOR_UID));
    }

    public boolean isEmpty() {
        return !parentCommentId.isPresent() && !parentAuthorUid.isPresent();
    }
}
