package ru.yandex.chemodan.eventlog.events.eventlog;

import java.math.BigInteger;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.comment.AbstractCommentEvent;
import ru.yandex.chemodan.eventlog.events.comment.CommentEvent;
import ru.yandex.chemodan.eventlog.events.comment.CommentEventType;
import ru.yandex.chemodan.eventlog.events.comment.CommentRef;
import ru.yandex.chemodan.eventlog.events.comment.LikeDislikeEvent;
import ru.yandex.chemodan.eventlog.events.comment.LikeDislikeEventType;
import ru.yandex.chemodan.eventlog.events.comment.ParentCommentRef;
import ru.yandex.chemodan.eventlog.events.space.ProductSpaceEvent;
import ru.yandex.chemodan.eventlog.events.space.SpaceEventType;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.test.Assert;

/**
 * @author buberman
 */
public class CallbackEventLogListenerTest {

    private String eventProcessed = null;

    @Test
    public void testEventProcessor() {
        CallbackEventLogListener listener = new CallbackEventLogListener();

        listener.registerProcessor(AbstractEvent.class, this::processAbstractEvent);
        listener.registerProcessor(AbstractCommentEvent.class, this::processAbstractCommentEvent);
        listener.registerProcessor(LikeDislikeEvent.class, this::processLikeDislikeEvent);

        DataApiUserId userId = DataApiUserId.parse("123456789");
        EventMetadata eventMetadata = new EventMetadata(MpfsUid.parse("qwerty"), Instant.now(), Option.empty());
        CommentRef commentRef = new CommentRef("123", MpfsUid.parse("123456"), "Comment text");

        AbstractEvent event = new LikeDislikeEvent(
                LikeDislikeEventType.LIKE_ADD,
                eventMetadata,
                null, null,
                commentRef,
                Cf.list());

        listener.runEventProcessor(userId, event);
        Assert.equals("LikeDislikeEvent", this.eventProcessed);

        event = new CommentEvent(
                CommentEventType.COMMENT_ADD,
                eventMetadata,
                null, null,
                commentRef,
                new ParentCommentRef(Option.empty(), Option.empty()),
                Cf.list());

        listener.runEventProcessor(userId, event);
        Assert.equals("AbstractCommentEvent", this.eventProcessed);

        event = new ProductSpaceEvent(SpaceEventType.ENLARGE, eventMetadata, BigInteger.ONE, BigInteger.TEN, null);
        listener.runEventProcessor(userId, event);
        Assert.equals("AbstractEvent", this.eventProcessed);
    }

    public void processAbstractEvent(DataApiUserId userId, AbstractEvent event) {
        this.eventProcessed = "AbstractEvent";
    }

    public void processAbstractCommentEvent(DataApiUserId userId, AbstractCommentEvent event) {
        this.eventProcessed = "AbstractCommentEvent";
    }

    public void processLikeDislikeEvent(DataApiUserId userId, LikeDislikeEvent event) {
        this.eventProcessed = "LikeDislikeEvent";
    }

}
