package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.chemodan.mpfs.MpfsResourceId;

/**
 * @author dbrylev
 */
public class DeleteSubdirFsEvent extends AbstractFsEvent {

    public final MpfsResourceId resourceId;

    public DeleteSubdirFsEvent(EventMetadata metadata, MpfsResourceId resourceId) {
        super(metadata);
        this.resourceId = resourceId;
    }

    public static DeleteSubdirFsEvent parse(TskvEventLogLine tskv) {
        return new DeleteSubdirFsEvent(tskv.getMetadata(), tskv.getResourceId());
    }

    @Override
    public EventType getEventType() {
        return EventType.DELETE_SUBDIR;
    }

    @Override
    public ListF<Object> getGroupChunks() {
        return Cf.list();
    }

    @Override
    public ListF<Object> getNameChunks() {
        return Cf.list();
    }
}
