package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class FsEventExtra extends DefaultObject {
    public static final FsEventExtra NONE = new FsEventExtra(StoreTypeSubtype.NONE, Option.empty());

    @BenderIgnore
    public final Option<Boolean> force;

    @BenderFlatten
    public final StoreTypeSubtype typeSubtype;

    @BenderPart(name = "invite_service", strictName = true)
    public final Option<String> providerId;

    public FsEventExtra(StoreTypeSubtype typeSubtype, Option<Boolean> force) {
        this.force = force;
        this.typeSubtype = typeSubtype;
        this.providerId = typeSubtype.extractProviderId();
    }

    public static FsEventExtra force(boolean force) {
        return new FsEventExtra(StoreTypeSubtype.NONE, Option.of(force));
    }

    public static FsEventExtra storeTypes(String type, String subtype) {
        return new FsEventExtra(new StoreTypeSubtype(type, subtype), Option.empty());
    }

    public static FsEventExtra storeTypes(Option<String> type, Option<String> subtype) {
        return new FsEventExtra(new StoreTypeSubtype(type, subtype), Option.empty());
    }
}
