package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventType;
import ru.yandex.chemodan.eventlog.events.SpecificEventTypeResolver;
import ru.yandex.chemodan.eventlog.log.TskvEventType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum FsEventType implements SpecificEventType {
    FS_MKDIR(TskvEventType.FS_MKDIR, EventType.FS_MKDIR),
    FS_STORE(TskvEventType.FS_STORE, event -> FsStoreEventType.byTypeSubtype(event.extra.typeSubtype).globalType),
    FS_HARDLINK_COPY(TskvEventType.FS_HARDLINK_COPY, event -> FsStoreEventType.byTypeSubtype(event.extra.typeSubtype).globalType),
    FS_COPY(TskvEventType.FS_COPY,
            event -> event.resourceChange.sourceIsForeignAndTargetIsNot()
                    ? EventType.FS_STORE_DOWNLOAD
                    : EventType.FS_COPY),
    FS_MOVE(TskvEventType.FS_MOVE, event -> event.resourceChange.parentEquals() ? EventType.FS_RENAME : EventType.FS_MOVE),
    FS_RM(TskvEventType.FS_RM, EventType.FS_RM),
    FS_TRASH_APPEND(TskvEventType.FS_TRASH_APPEND, EventType.FS_TRASH_APPEND),
    FS_TRASH_RESTORE(TskvEventType.FS_TRASH_RESTORE, EventType.FS_TRASH_RESTORE),
    FS_TRASH_DROP(TskvEventType.FS_TRASH_DROP, EventType.FS_TRASH_DROP),
    FS_SET_PRIVATE(TskvEventType.FS_SET_PRIVATE, EventType.FS_SET_PRIVATE),
    FS_SET_PUBLIC(TskvEventType.FS_SET_PUBLIC, EventType.FS_SET_PUBLIC),
    ;

    final TskvEventType tskvType;

    final Function<FsEvent, EventType> globalTypeF;

    FsEventType(TskvEventType tskvType, EventType globalType) {
        this(tskvType, event -> globalType);
    }

    FsEventType(TskvEventType tskvType, Function<FsEvent, EventType> globalTypeF) {
        this.tskvType = tskvType;
        this.globalTypeF = globalTypeF;
    }

    public final EventType getGlobalType(FsEvent event) {
        return globalTypeF.apply(event);
    }

    @Override
    public TskvEventType getTskvType() {
        return tskvType;
    }

    public static final SpecificEventTypeResolver<FsEventType> R = new SpecificEventTypeResolver<>(values());
}
