package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.eventlog.events.Resource;
import ru.yandex.chemodan.eventlog.events.ResourceLocation;

/**
 * @author Dmitry Amelin (lemeh)
 */
public final class FsEvents {
    public static FsEvent mkdir(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_MKDIR, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource)
        );
    }

    public static FsEvent store(EventMetadata metadata, ResourceLocation target, Resource resource,
            String type, String subtype)
    {
        return new FsEvent(FsEventType.FS_STORE, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource),
                FsEventExtra.storeTypes(type, subtype));
    }

    public static FsEvent socialImport(EventMetadata metadata, ResourceLocation target, Resource resource,
            String subtype)
    {
        return new FsEvent(FsEventType.FS_STORE, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource),
                FsEventExtra.storeTypes(StoreTypeSubtype.SOCIAL_COPY_TYPE, subtype));
    }

    public static FsEvent aviaryRender(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_STORE, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource),
                FsEventExtra.storeTypes(StoreTypeSubtype.SOCIAL_COPY_TYPE, "aviary_disk"));
    }

    public static FsEvent copy(EventMetadata metadata, ResourceLocation source, ResourceLocation target,
            Resource resource, boolean force) {
        return new FsEvent(FsEventType.FS_COPY, metadata,
                FsEventResourceChange.sourceAndTarget(metadata.uid, source, target, resource),
                FsEventExtra.force(force));
    }

    public static FsEvent move(EventMetadata metadata, ResourceLocation source, ResourceLocation target,
            Resource resource, boolean force)
    {
        return new FsEvent(FsEventType.FS_MOVE, metadata,
                FsEventResourceChange.sourceAndTarget(metadata.uid, source, target, resource),
                FsEventExtra.force(force));
    }

    public static FsEvent trashAppend(EventMetadata metadata, ResourceLocation source, ResourceLocation target,
            Resource resource)
    {
        return new FsEvent(FsEventType.FS_TRASH_APPEND, metadata,
                FsEventResourceChange.sourceAndTarget(metadata.uid, source, target, resource));
    }

    public static FsEvent trashDrop(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_TRASH_DROP, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource));
    }

    public static FsEvent trashRestore(EventMetadata metadata, ResourceLocation source, ResourceLocation target,
            Resource resource, Option<String> type, Option<String> subtype)
    {
        return new FsEvent(FsEventType.FS_TRASH_RESTORE, metadata,
                FsEventResourceChange.sourceAndTarget(metadata.uid, source, target, resource),
                FsEventExtra.storeTypes(type, subtype));
    }

    public static FsEvent rm(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_RM, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource));
    }

    public static FsEvent setPrivate(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_SET_PRIVATE, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource));
    }

    public static FsEvent setPublic(EventMetadata metadata, ResourceLocation target, Resource resource) {
        return new FsEvent(FsEventType.FS_SET_PUBLIC, metadata,
                FsEventResourceChange.target(metadata.uid, target, resource));
    }

    private FsEvents() {}
}
