package ru.yandex.chemodan.eventlog.events.fs;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.eventlog.events.EventType;

/**
 * @author Dmitriy Amelin (lemeh)
 * Object is publised to search
 */
public enum FsStoreEventType {
    STORE(EventType.FS_STORE, type("store", "disk")),
    UPDATE(EventType.FS_STORE_UPDATE, type("dstore", "disk"), type("overwrite", "disk")),
    DOWNLOAD(EventType.FS_STORE_DOWNLOAD, type("external_copy", "web_disk"), type("store", "attach")),
    PHOTOSTREAM(EventType.FS_STORE_PHOTOSTREAM, type("store", "photostream")),
    PHOTOUNLIM(EventType.FS_STORE_PHOTOUNLIM, type("store", "photounlim")),
    AVIARY(EventType.FS_AVIARY_RENDER, type("social_copy", "aviary_disk")),
    SOCIAL_IMPORT(EventType.SOCIAL_IMPORT, type("social_copy", "[a-z0-9_]+_disk")),
    OFFICE(EventType.FS_STORE_OFFICE, type("office", "overwrite")),
    SETTINGS(EventType.SKIP, type("overwrite", "settings"), type("store", "settings")),
    SKIP(EventType.SKIP)
    ;

    private static StoreTypeSubtype type(String type, String subtype) {
        return new StoreTypeSubtype(type, subtype);
    }

    final EventType globalType;

    private final SetF<StoreTypeSubtype> storeTypes;

    FsStoreEventType(EventType globalType, StoreTypeSubtype... storeTypes) {
        this.globalType = globalType;
        this.storeTypes = Cf.set(storeTypes);
    }

    public static FsStoreEventType byTypeSubtype(StoreTypeSubtype typeSubtype) {
        for(FsStoreEventType type : values()) {
            for (StoreTypeSubtype matcher : type.storeTypes) {
                if (matcher.matches(typeSubtype)) {
                    return type;
                }
            }
        }
        return SKIP;
    }
}
